/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpCommon.GraphDefinition;
import ibm.nways.analysis.dpCommon.GraphPollingObjectDefinition;
import ibm.nways.analysis.dpCommon.SortedStringVector;
import ibm.nways.analysis.dpManager.Admin.BasicConfigPanel;
import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.Admin.IdSelector;
import ibm.nways.analysis.dpManager.VectorUtil;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.nhm.eui.AccumulatorBox;
import java.applet.Applet;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;

public class GraphDef
extends BasicConfigPanel
implements ItemListener,
JCItemListener,
JCActionListener,
TextListener {
    private boolean graphUnitsInitializing = true;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String NEW_BUTTON_LABEL = adminRB.getString("s_New");
    private static final String DELETE_BUTTON_LABEL = adminRB.getString("s_Delete");
    private static final String ADD_STRING = adminRB.getString("s_Add");
    private static final String REMOVE_STRING = adminRB.getString("s_Remove");
    private static final String EDIT_STRING = adminRB.getString("s_Edit");
    private static final String LOADED_POD_NAMES = adminRB.getString("s_LoadedPODNames");
    private static final String APPLIED_POD_NAMES = adminRB.getString("s_AppliedPODNames");
    private static final String GRAPH_ID_LABEL = adminRB.getString("s_GraphLabel");
    private static final String GRAPH_UNITS_LABEL = adminRB.getString("s_GraphUnitsLabel");
    private static final String GRAPH_TYPE_LABEL = adminRB.getString("s_GraphTypeLabel");
    private static final String PLOT_STRING = adminRB.getString("s_Plot");
    private static final String BAR_STRING = adminRB.getString("s_Bar");
    private static final String STACKING_BAR_STRING = adminRB.getString("s_StackingBar");
    private static final String PIE_STRING = adminRB.getString("s_Pie");
    private static final String PERCENT_100_STRING = adminRB.getString("s_Percent100");
    private DpAdminPanel adminPanel;
    private Vector podCurrentlyAssociated;
    private String previous;
    private TextField graphUnits;
    private Choice graphType;
    private IdSelector graphID;
    private AccumulatorBox podBox;

    public GraphDef(DpAdminPanel dpAdminPanel, Applet applet) {
        super(applet);
        this.adminPanel = dpAdminPanel;
        this.graphID = new IdSelector(GRAPH_ID_LABEL, true);
        this.add("North", this.graphID);
        this.graphID.addActionListener(this);
        this.graphID.addItemListener(this);
        this.podBox = new AccumulatorBox(new Vector(), new Vector(), 5, LOADED_POD_NAMES, APPLIED_POD_NAMES, ADD_STRING, REMOVE_STRING, EDIT_STRING, 200, 125);
        this.podBox.addItemListener(this);
        Panel panel = new Panel(new ColumnLayout(20));
        Panel panel2 = new Panel(new JCAlignerLayout(2, 10, 10));
        Label label = new Label(GRAPH_TYPE_LABEL);
        this.graphType = new Choice();
        this.graphType.removeAll();
        Enumeration enumeration = GraphDef.getGraphTypes().elements();
        while (enumeration.hasMoreElements()) {
            this.graphType.add((String)enumeration.nextElement());
        }
        this.graphType.setVisible(true);
        this.graphType.addItemListener(this);
        Label label2 = new Label(GRAPH_UNITS_LABEL);
        this.graphUnits = new TextField(18);
        this.graphUnits.addTextListener(this);
        panel2.add(label);
        panel2.add(this.graphType);
        panel2.add(label2);
        panel2.add(this.graphUnits);
        Panel panel3 = new Panel(new FlowLayout(1));
        panel3.add(panel2);
        panel.add(panel3);
        panel.add(this.podBox);
        this.add("Center", panel);
    }

    protected void save() {
        if (this.isDirty()) {
            Vector vector = VectorUtil.stringsToVector(this.podBox.getRightListItems());
            Vector vector2 = VectorUtil.findAdditions(this.podCurrentlyAssociated, vector);
            Vector vector3 = VectorUtil.findDeletions(this.podCurrentlyAssociated, vector);
            this.podCurrentlyAssociated = vector;
            try {
                if (this.adminPanel.getClientApplet().getGraphDefinition(this.graphID.getSelectedItem()) == null) {
                    GraphDefinition graphDefinition = new GraphDefinition(this.graphID.getSelectedItem());
                    graphDefinition.setGraphType(GraphDef.toGraphType(this.graphType.getSelectedItem()));
                    graphDefinition.setUnits(this.graphUnits.getText());
                    if (vector2 != null) {
                        Enumeration enumeration = vector2.elements();
                        while (enumeration != null && enumeration.hasMoreElements()) {
                            GraphPollingObjectDefinition graphPollingObjectDefinition = new GraphPollingObjectDefinition((String)enumeration.nextElement());
                            graphDefinition.addPollingObject(graphPollingObjectDefinition);
                        }
                    }
                    this.adminPanel.getClientApplet().addGraphDefinition(graphDefinition);
                    this.graphID.addId(this.graphID.getSelectedItem());
                    this.graphID.select(this.graphID.getSelectedItem());
                } else {
                    this.adminPanel.getClientApplet().modifyGraphDefinition(this.graphID.getSelectedItem(), GraphDef.toGraphType(this.graphType.getSelectedItem()), this.graphUnits.getText(), vector2, vector3);
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            this.setDirty(false);
        }
    }

    protected void cancel() {
        if (this.previous != null) {
            this.selectItem(this.previous);
        } else {
            if (this.graphID.getSelectedIndex() < 0) {
                this.graphID.select(0);
            }
            this.displayGraphInfo(this.graphID.getSelectedItem());
        }
        this.setDirty(false);
    }

    public static int toGraphType(String string) {
        int n = -2;
        if (string.equals(PLOT_STRING)) {
            n = 0;
        } else if (string.equals(BAR_STRING)) {
            n = 9;
        } else if (string.equals(STACKING_BAR_STRING)) {
            n = 10;
        } else if (string.equals(PIE_STRING)) {
            n = 11;
        } else if (string.equals(PERCENT_100_STRING)) {
            n = -1;
        }
        return n;
    }

    public static String toString(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = PLOT_STRING;
                break;
            }
            case 9: {
                string = BAR_STRING;
                break;
            }
            case 10: {
                string = STACKING_BAR_STRING;
                break;
            }
            case 11: {
                string = PIE_STRING;
                break;
            }
            case -1: {
                string = PERCENT_100_STRING;
            }
        }
        return string;
    }

    public static Vector getGraphTypes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(GraphDef.toString(0));
        vector.addElement(GraphDef.toString(9));
        vector.addElement(GraphDef.toString(10));
        vector.addElement(GraphDef.toString(11));
        vector.addElement(GraphDef.toString(-1));
        return vector;
    }

    protected void populate() {
        String string = null;
        if (this.graphID.getSelectedItem() != null) {
            string = this.graphID.getSelectedItem();
        }
        Vector vector = null;
        try {
            vector = this.adminPanel.getClientApplet().getGraphNamesList();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (vector != null) {
            this.graphID.removeAllIds();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.graphID.addId((String)enumeration.nextElement());
            }
        }
        if (this.graphID.getItemCount() > 0) {
            if (string == null || string.length() == 0) {
                string = this.graphID.getItem(0);
            }
            this.selectItem(string);
        }
    }

    public void selectItem(String string) {
        this.graphID.select(string);
    }

    protected void displayGraphInfo(String string) {
        GraphDefinition graphDefinition = null;
        Vector vector = null;
        SortedStringVector sortedStringVector = null;
        try {
            vector = this.adminPanel.getClientApplet().getPollingObjectDefinitionList();
            graphDefinition = this.adminPanel.getClientApplet().getGraphDefinition(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        Vector vector2 = null;
        if (graphDefinition != null) {
            sortedStringVector = new SortedStringVector(graphDefinition.getPollingIdentifiers());
            vector2 = VectorUtil.diffOfTwoVectors(vector, sortedStringVector);
        } else {
            vector2 = vector;
            sortedStringVector = null;
        }
        this.podBox.setLeftList(vector2);
        this.podBox.setRightList(sortedStringVector);
        this.podBox.reset();
        this.podCurrentlyAssociated = sortedStringVector;
        if (graphDefinition != null) {
            this.graphUnitsInitializing = true;
            this.graphType.select(GraphDef.toString(graphDefinition.getGraphType()));
            ((TextComponent)this.graphUnits).setText(graphDefinition.getUnits());
            this.setDirty(false);
            return;
        }
        this.graphType.select(GraphDef.toString(0));
        this.graphUnitsInitializing = true;
        ((TextComponent)this.graphUnits).setText("");
        this.setDirty(true);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.graphID && jCActionEvent.getActionCommand().equals(NEW_BUTTON_LABEL)) {
            String string = this.graphID.getSelectedItem();
            boolean bl = false;
            Vector vector = null;
            try {
                vector = this.adminPanel.getClientApplet().getGraphNamesList();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.selectItem(string);
                return;
            }
            this.displayGraphInfo(string);
            this.setDirty(true);
            return;
        }
        if (jCActionEvent.getSource() == this.graphID && jCActionEvent.getActionCommand().equals(DELETE_BUTTON_LABEL)) {
            String string = null;
            try {
                string = this.adminPanel.getClientApplet().removeGraphDefinition(this.graphID.getSelectedItem());
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            if (string == null) {
                int n = this.graphID.getSelectedIndex();
                this.graphID.removeId(this.graphID.getSelectedItem());
                if (n > 0 && this.graphID.getItemCount() > n) {
                    this.graphID.select(n);
                    return;
                }
                if (this.graphID.getItemCount() > 0) {
                    this.graphID.select(0);
                    this.displayGraphInfo(this.graphID.getSelectedItem());
                    return;
                }
                this.displayGraphInfo("");
                return;
            }
            String string3 = String.valueOf(adminRB.getString("s_MsgGraphDeleteFailure")) + string;
            new MessageBox(this.getParentFrame(), adminRB.getString("s_MsgDeleteFail"), string3, true);
            return;
        }
        super.actionPerformed(jCActionEvent);
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.graphUnits) {
            if (this.graphUnitsInitializing) {
                this.graphUnitsInitializing = false;
                return;
            }
            this.setDirty(true);
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() == this.podBox) {
            if (jCItemEvent.getStateChange() == 1) {
                this.adminPanel.getDpePollDefs().selectItem(jCItemEvent.getItem().toString());
                this.adminPanel.setPage(adminRB.getString("s_PODConfig"));
                return;
            }
            if ((jCItemEvent.getStateChange() & 0xC00) != 0) {
                this.setDirty(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.graphID && itemEvent.getStateChange() == 1) {
            this.previous = (String)itemEvent.getItem();
            this.displayGraphInfo((String)itemEvent.getItem());
            return;
        }
        if (itemEvent.getSource() == this.graphType) {
            this.setDirty(true);
        }
    }
}

